# Boltlytics - URL Shortener with Analytics PRD

## Original Problem Statement
Build a professional URL Shortener with Analytics platform with:
- Subscription-based plans (Free: 3 links/month, Basic: 30, Pro: 300, Ultimate: 1000 + custom domains, Enterprise)
- Admin login and User login
- Referrer tracking, Location tracking, IP tracking
- Light/dark theme option
- API system (provide API keys to users)
- Password protected links
- Ad monetization (interstitial ads before redirect)
- Payment options (Stripe with card + crypto)
- QR code generation
- Click analytics (geographic, device, browser, referrer)
- Link expiration options
- Rate limiting

## User Personas
1. **Marketers** - Need link tracking and campaign analytics
2. **Developers** - Require API access for programmatic link management
3. **Content Creators** - Want to monetize links with ads
4. **Enterprises** - Need branded short links with custom domains

## Core Requirements
| Feature | Status | Priority |
|---------|--------|----------|
| URL Shortening | ✅ Complete | P0 |
| Custom Aliases | ✅ Complete | P0 |
| Click Analytics | ✅ Complete | P0 |
| User Authentication | ✅ Complete | P0 |
| Admin Dashboard | ✅ Complete | P0 |
| Subscription Plans | ✅ Complete | P0 |
| Stripe Payment (Card + Crypto) | ✅ Complete | P0 |
| QR Code Generation | ✅ Complete | P0 |
| Password Protection | ✅ Complete | P1 |
| Link Expiration | ✅ Complete | P1 |
| API Key System | ✅ Complete | P1 |
| Dark/Light Theme | ✅ Complete | P1 |
| Interstitial Ads | ✅ Complete | P1 |
| Referrer Tracking | ✅ Complete | P1 |
| Device/Browser Tracking | ✅ Complete | P1 |

## What's Been Implemented (Jan 2026)

### Backend (FastAPI + MongoDB)
- User authentication with JWT tokens
- Admin and user roles
- Link CRUD operations with custom aliases
- Click tracking (IP, browser, device, referrer, timestamp)
- Analytics aggregation (by country, browser, device, referrer)
- API key generation and authentication
- Subscription plans with link limits
- Stripe checkout integration (card + crypto)
- Password-protected links
- Link expiration
- QR code auto-generation

### Frontend (React + Tailwind + Shadcn/UI)
- Landing page with hero, features, pricing
- User registration and login
- User dashboard with stats and charts
- Link management (create, edit, delete)
- Detailed link analytics with charts
- API key management
- Admin dashboard (users, links, revenue, plan management)
- Settings with subscription upgrade
- Pricing page
- Interstitial ad page with countdown
- Dark/Light theme toggle
- Responsive design

## Tech Stack
- **Backend**: FastAPI, MongoDB, Python
- **Frontend**: React 19, Tailwind CSS, Shadcn/UI, Recharts
- **Payments**: Stripe (via emergentintegrations)
- **Authentication**: JWT + bcrypt

## Prioritized Backlog

### P0 (Critical)
- [x] All P0 features implemented

### P1 (Important)
- [ ] GeoIP integration for accurate location data
- [ ] Email verification for new users
- [ ] Password reset functionality

### P2 (Nice to Have)
- [ ] Custom domain integration for Ultimate plan
- [ ] Bulk link import/export
- [ ] Team collaboration features
- [ ] Webhook notifications for click events
- [ ] White-label configuration for Enterprise
- [ ] Advanced link scheduling
- [ ] A/B testing for links
- [ ] Crypto payouts for ad revenue

## Default Credentials
- **Admin**: admin@shortlytics.com / admin123

## API Documentation
Base URL: `/api`

### Authentication
- `POST /api/auth/register` - Create account
- `POST /api/auth/login` - Login
- `GET /api/auth/me` - Get current user

### Links
- `POST /api/links` - Create link
- `GET /api/links` - List user's links
- `GET /api/links/{id}` - Get link details
- `PUT /api/links/{id}` - Update link
- `DELETE /api/links/{id}` - Delete link
- `GET /api/links/{id}/analytics` - Get link analytics

### API Keys (Pro+ only)
- `POST /api/api-keys` - Create API key
- `GET /api/api-keys` - List API keys
- `DELETE /api/api-keys/{id}` - Delete API key

### Public API (with API key)
- `POST /api/v1/links` - Create link
- `GET /api/v1/links` - List links
- `GET /api/v1/links/{id}/analytics` - Get analytics
